﻿using System;
using System.IO;
using System.IdentityModel.Tokens.Jwt;
using Microsoft.IdentityModel.Tokens;

namespace Axinom.Drm.LicenseTokenGenerationExamples
{
    internal class Program
    {
        // Replace with Your 32-byte communication key.
        // Example values from the documentation are used in this current sample.
        private const string CommunicationKeyAsBase64 = "SGEpLQJ+JpeRCTMn5izu/b6kiaTH5aSXTMkEuED9fA8=";

        // Replace with Your communication Key ID.
        // Be sure to replace the "com_key_id" in the "Message.json" file accordingly.
        private const string CommunicationKeyIdAsGuidString = "69e54088-e9e0-4530-8c1a-1eb6dcd0d14e";

        private static void Main()
        {
            Console.WriteLine("Token generated from Json");
            GenerateLicenseTokenFromJson();

            Console.WriteLine("Token generated from code");
            GenerateLicenseTokenFromCode();

            Console.WriteLine("Press any key to quit...");
            Console.ReadKey();
        }

        private static void GenerateLicenseTokenFromJson()
        {
            var contents = File.ReadAllText("Message.json");
            var payload = JwtPayload.Deserialize(contents);

            CreateJwtToken(payload);
        }

        private static void GenerateLicenseTokenFromCode()
        {
            var payload = new JwtPayload
            {
                { "version", 1 },
                { "com_key_id", CommunicationKeyIdAsGuidString },
                { "message", new JwtPayload
                    {
                        { "type", "entitlement_message" },
                        { "version", 2 }, 
                        { "content_keys_source", new JwtPayload
                            {
                                { "inline", new []
                                    {
                                        new JwtPayload
                                        {
                                            { "id", "7459975d-b2f8-48ed-a325-56e4f34d19c7" }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            };

            CreateJwtToken(payload);
        }


        private static void CreateJwtToken(JwtPayload payload)
        {
            var symmetricKey = Convert.FromBase64String(CommunicationKeyAsBase64);
            var credentials = new SigningCredentials(new SymmetricSecurityKey(symmetricKey), "HS256");
            var header = new JwtHeader(credentials);

            var token = new JwtSecurityToken(header, payload);
            var handler = new JwtSecurityTokenHandler();
            var tokenAsString = handler.WriteToken(token);

            Console.WriteLine(tokenAsString + Environment.NewLine);
        }
    }
}